<?php

	class WS_Form_Config_SVG {

		// SVG - Logo
		public static function get_logo_svg($color_1 = '#002d5d', $color_2 = '#a7a8aa') {

			return sprintf('<svg id="wsf_logo" viewBox="0 0 1500 428"><path fill="%1$s" d="m215.2 422.9-44.3-198.4c-.4-1.4-.7-3-1-4.6-.3-1.6-3.4-18.9-9.3-51.8h-.6l-4.1 22.9-6.8 33.5-45.8 198.4H69.7L0 130.1h28.1L68 300.7l18.6 89.1h1.8c3.5-25.7 9.3-55.6 17.1-89.6l39.9-170H175l40.2 170.6c3.1 12.8 8.8 42.5 16.8 89.1h1.8c.6-5.9 3.5-20.9 8.7-44.8 5.2-23.9 21.9-95.5 50.1-214.8h27.8l-72.1 292.8h-33.1zM495 349.5c0 24.7-7.1 44-21.3 57.9-14.2 13.9-34.7 20.9-61.5 20.9-14.6 0-27.4-1.7-38.4-5.1-11-3.4-19.6-7.2-25.7-11.3l12.3-21.3c8.3 5.1 5.9 3.6 16.6 7.4 12 4.2 24.3 6.1 36.9 6.1 16.5 0 29.6-4.9 39-14.8 9.5-9.9 14.2-23.1 14.2-39.7 0-13-3.4-23.9-10.2-32.8-6.8-8.9-19.8-19-38.9-30.4-21.9-12.6-36.8-22.7-44.8-30.2-8-7.6-14.2-16-18.6-25.4-4.4-9.4-6.6-20.5-6.6-33.5 0-21.1 7.8-38.5 23.3-52.2 15.6-13.8 35.4-20.6 59.4-20.6 25.8 0 45.2 6.7 62.6 17.8L481 163.6c-16.2-9.9-33.3-14.8-51.4-14.8-16.6 0-29.8 4.5-39.6 13.4-9.9 8.9-14.8 20.6-14.8 35.2 0 13 3.3 23.8 10 32.5s20.9 19.3 42.6 31.7c21.3 12.8 35.9 23 43.7 30.6 7.9 7.6 13.7 16.1 17.6 25.4 4 9.2 5.9 19.9 5.9 31.9z"/><path fill="%2$s" d="M643.8 152.8h-50.2V423h-27.8V152.8H525l.2-22.3h40.3l.3-25.5c0-37.2 3.6-60.9 13.4-77.2C589.5 10.7 606.6 0 630.5 0h28.9v23.6c-6.4 0-18.9.2-27.3.4-13.9.2-20.1 4.5-25.1 9.7-4.9 5.2-7.5 11.5-9.9 23.2-2.4 11.7-3.5 27.9-3.5 48.6v24.6h50.2v22.7zM857.1 275.8c0 49.3-8.5 87-25.6 113.2-17 26.2-41.4 39.3-73.1 39.3-31.3 0-55.3-13.1-72-39.3-16.7-26.2-25-63.9-25-113.2 0-100.9 32.7-151.4 98.1-151.4 30.7 0 54.7 13.2 71.8 39.7 17.2 26.4 25.8 63.7 25.8 111.7zm-166.4 0c0 42.3 5.5 74.2 16.6 95.8 11 21.6 28.3 32.4 51.7 32.4 45.9 0 68.9-42.7 68.9-128.2 0-84.7-23-127.1-68.9-127.1-24 0-41.4 10.6-52.2 31.8-10.7 21.3-16.1 53.1-16.1 95.3zM901.8 196.5c0-35.5 42.9-71.7 88.5-72 30.9-.3 42 8.6 53.2 13.7l-13.9 21.6c-9.7-5.1-18.8-9.2-39.9-9.9-13.3-.4-24.1 1.4-35.9 9.3-9.7 6.4-20.4 12.9-23.6 40.8-2.2 19-.8 45.9-.8 67.8V423h-28.1M1047.6 191.4c5.6-48.2 49.8-67.2 80.6-67.2 17.7 0 39.6 6.4 50.2 14.5 9.5 7.2 14.7 13.4 20.3 32.2 7.7-18 13.9-23.4 25.1-31.3 11.2-7.9 25.8-14.9 43.7-14.9 24.2 0 48.4 7.5 62.9 28.5 11.6 16.7 16.8 41 16.8 78.4V423h-27.8V223.5c.7-56.9-14.3-75.2-52-75.2-18.7 0-32.2 4.7-42.2 21.9-9.8 17-14.3 47.9-14.3 81.3v171.4h-27.8V223.5c0-24.8-3.8-43.3-11.5-55.5s-26.7-18.6-42.8-18.6c-21.3 0-35.6 10.4-45.3 28-9.7 17.6-8.6 45.1-8.6 84.6v160.9h-28.1"/><circle fill="%2$s" cx="1412.6" cy="149.4" r="25.3"/><circle fill="%2$s" cx="1412.6" cy="273" r="25.3"/><circle fill="%2$s" cx="1412.6" cy="395" r="25.3"/><path fill="%2$s" d="M1449.5 85.4c0-2.2.3-4.3.9-6.4.6-2 1.4-3.9 2.4-5.7 1-1.8 2.3-3.4 3.7-4.8 1.5-1.4 3.1-2.7 4.8-3.7 1.8-1 3.7-1.9 5.7-2.4 2-.6 4.1-.9 6.3-.9s4.3.3 6.4.9c2 .6 3.9 1.4 5.7 2.4 1.8 1 3.4 2.3 4.8 3.7 1.5 1.5 2.7 3.1 3.7 4.8 1 1.8 1.8 3.7 2.4 5.7.6 2 .8 4.2.8 6.4s-.3 4.3-.8 6.3c-.6 2-1.4 3.9-2.4 5.7-1 1.8-2.3 3.4-3.7 4.8-1.5 1.5-3.1 2.7-4.8 3.7-1.8 1-3.7 1.9-5.7 2.4-2 .6-4.2.9-6.4.9s-4.3-.3-6.3-.9c-2-.6-3.9-1.4-5.7-2.4-1.8-1-3.4-2.3-4.8-3.7-1.5-1.4-2.7-3.1-3.7-4.8-1-1.8-1.8-3.7-2.4-5.7s-.9-4.1-.9-6.3zm3.2 0c0 1.9.2 3.8.7 5.6.5 1.8 1.2 3.5 2.1 5 .9 1.6 2 3 3.2 4.2 1.2 1.3 2.6 2.3 4.2 3.3 1.5.9 3.2 1.6 4.9 2.1 1.8.5 3.6.7 5.5.7 2.9 0 5.6-.5 8.1-1.6s4.7-2.6 6.6-4.5c1.9-1.9 3.3-4.1 4.4-6.6 1.1-2.5 1.6-5.3 1.6-8.2 0-1.9-.2-3.8-.7-5.6-.5-1.8-1.2-3.5-2.1-5.1-.9-1.6-2-3-3.2-4.3-1.3-1.3-2.6-2.4-4.2-3.3-1.5-.9-3.2-1.6-5-2.1-1.8-.5-3.6-.8-5.5-.8-2.9 0-5.6.6-8.1 1.7s-4.7 2.6-6.5 4.5c-1.9 1.9-3.3 4.1-4.4 6.7-1 2.6-1.6 5.3-1.6 8.3zm17.3 2.5v7.9h-3.5V75.9h6.4c2.6 0 4.4.5 5.7 1.4 1.2.9 1.8 2.3 1.8 4.1 0 1.4-.4 2.6-1.2 3.6-.8 1-2 1.7-3.6 2 .3.1.5.3.7.6.2.2.4.5.5.8l5.1 7.4h-3.3c-.5 0-.9-.2-1.1-.6l-4.5-6.7c-.1-.2-.3-.3-.5-.4-.2-.1-.5-.2-.9-.2h-1.6zm0-2.6h2.6c.8 0 1.5-.1 2.1-.2.6-.2 1-.4 1.4-.7.3-.3.6-.7.8-1.1.2-.4.2-.9.2-1.5 0-.5-.1-1-.2-1.4-.1-.4-.4-.8-.7-1-.3-.3-.7-.5-1.3-.6-.5-.1-1.2-.2-1.9-.2h-2.9v6.7z"/></svg>', esc_attr($color_1), esc_attr($color_2));
		}

		// SVG - Icon 24 x 24 pixel
		public static function get_icon_24_svg($id = '') {

			$return_value = false;

			switch($id) {

				case 'bp-25' :

					$return_value = '<path d="M15.5 1h-8C6.12 1 5 2.12 5 3.5v17C5 21.88 6.12 23 7.5 23h8c1.38 0 2.5-1.12 2.5-2.5v-17C18 2.12 16.88 1 15.5 1zm-4 21c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5-4H7V4h9v14z"/>';
					break;

				case 'bp-50' :

					$return_value = '<path d="M18.5 0h-14C3.12 0 2 1.12 2 2.5v19C2 22.88 3.12 24 4.5 24h14c1.38 0 2.5-1.12 2.5-2.5v-19C21 1.12 19.88 0 18.5 0zm-7 23c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm7.5-4H4V3h15v16z"/>';
					break;

				case 'bp-75' :

					$return_value = '<path d="M20 18c1.1 0 1.99-.9 1.99-2L22 5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2H0c0 1.1.9 2 2 2h20c1.1 0 2-.9 2-2h-4zM4 5h16v11H4V5zm8 14c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z"/>';
					break;

				case 'bp-100' :

					$return_value = '<path d="M21 2H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h7l-2 3v1h8v-1l-2-3h7c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 12H3V4h18v10z"/>';
					break;

				case 'bp-125' :

					$return_value = '<path d="M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v2h8v-2h5c1.1 0 1.99-.9 1.99-2L23 5c0-1.1-.9-2-2-2zm0 14H3V5h18v12z"/>';
					break;

				case 'bp-150' :

					$return_value = '<path d="M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v2h8v-2h5c1.1 0 1.99-.9 1.99-2L23 5c0-1.1-.9-2-2-2zm0 14H3V5h18v12z"/>';
					break;
			}

			return sprintf('<svg height="24" width="24" viewBox="0 0 24 24">%s</svg>', $return_value);
		}
		// SVG - Icon 16 x 16 pixel
		public static function get_icon_16_svg($id = '') {

			$return_value = false;

			switch($id) {

				case 'actions' :

					$return_value = '<path d="M7.99 0l-7.010 9.38 6.020-0.42-4.96 7.040 12.96-10-7.010 0.47 7.010-6.47h-7.010z"/>';
					break;

				case 'asterisk' :

					$return_value = '<path d="M15.9 5.7l-2-3.4-3.9 2.2v-4.5h-4v4.5l-4-2.2-2 3.4 3.9 2.3-3.9 2.3 2 3.4 4-2.2v4.5h4v-4.5l3.9 2.2 2-3.4-4-2.3z"/>';
					break;

				case 'button' :

					$return_value = '<path d="M15 12h-14c-0.6 0-1-0.4-1-1v-6c0-0.6 0.4-1 1-1h14c0.6 0 1 0.4 1 1v6c0 0.6-0.4 1-1 1z"/>';
					break;

				case 'calc' :

					$return_value = '<path d="M9 3h6v2h-6v-2z"/><path d="M9 11h6v2h-6v-2z"/><path d="M5 1h-2v2h-2v2h2v2h2v-2h2v-2h-2z"/><path d="M7 10.4l-1.4-1.4-1.6 1.6-1.6-1.6-1.4 1.4 1.6 1.6-1.6 1.6 1.4 1.4 1.6-1.6 1.6 1.6 1.4-1.4-1.6-1.6z"/><path d="M13 14.5c0 0.552-0.448 1-1 1s-1-0.448-1-1c0-0.552 0.448-1 1-1s1 0.448 1 1z"/><path d="M13 9.5c0 0.552-0.448 1-1 1s-1-0.448-1-1c0-0.552 0.448-1 1-1s1 0.448 1 1z"/>';
					break;

				case 'calculator' :

					$return_value = '<path d="M14.1 1.7v12.7c-.1.4-.2.8-.5 1-.4.4-.8.6-1.3.6h-9c-.4-.1-.8-.3-1.1-.6-.2-.4-.4-.7-.4-1.2V1.9c0-.3.1-.7.3-1 .3-.5.7-.8 1.2-.9h9.1c.2 0 .4.1.6.2.5.3.9.7 1 1.3.1.1.1.2.1.2zM7.9 5.6H12.3c.3-.1.5-.3.5-.6V1.9c0-.1 0-.2-.1-.3-.1-.2-.3-.3-.6-.3H3.6c-.3 0-.6.2-.6.6V5c0 .2.1.3.2.4.1.1.3.2.5.2h4.2zm3.7 3h.6c.3 0 .5-.3.6-.5v-.7-.1c-.1-.3-.3-.5-.6-.5H11h-.1c-.2 0-.5.3-.5.5V8.1c.1.3.3.5.6.5h.6zm0 3.1h.7c.3 0 .5-.3.6-.5v-.7c0-.3-.3-.6-.6-.6h-1.2-.1c-.3 0-.5.3-.5.5V11.2c.1.3.3.4.6.4.1.1.3.1.5.1zm0 3.1h.8c.3-.1.5-.3.5-.5v-.7c0-.3-.3-.6-.6-.6h-1.2-.1c-.2 0-.5.3-.5.5v.8c0 .3.3.5.6.5h.5zM4.3 8.6h.6c.3 0 .6-.3.6-.6v-.7c0-.3-.3-.6-.6-.6H3.7c-.4.1-.7.4-.7.7v.7c.1.3.3.5.6.5h.7zm0 3.1h.6c.3 0 .6-.3.6-.6v-.7c0-.3-.3-.6-.6-.6H3.6c-.3.1-.6.4-.6.7v.7c.1.3.3.5.6.5h.7zm3.6 3.1h.6c.3 0 .6-.3.6-.6v-.6c0-.3-.3-.6-.6-.6H7.2c-.3 0-.6.3-.6.6V14.4c.1.3.3.5.6.5.3-.1.5-.1.7-.1zm0-3.1h.6c.3 0 .6-.3.6-.6v-.6-.1c0-.3-.3-.5-.6-.5H7.2c-.3 0-.6.3-.6.6v.7c0 .3.3.6.6.6.3-.1.5-.1.7-.1zm-3.6 3.1H5c.3 0 .6-.3.6-.6v-.7c0-.3-.3-.6-.6-.6H3.7h-.1c-.4.1-.6.4-.6.7v.7c.1.3.3.5.6.5h.7zm3.6-6.2h.7c.3 0 .5-.2.6-.5v-.4-.4c0-.3-.3-.6-.6-.6H7.4h-.1c-.3 0-.5.3-.5.6V8.1c.1.3.3.5.6.5h.5z"/><path d="M3.5 0h-.2c-.6.2-1 .5-1.2 1-.2.3-.3.6-.3 1v12.3c0 .4.2.8.4 1.2.3.3.6.5 1.1.6h9c.5 0 1-.2 1.3-.6.3-.3.4-.6.5-1v-.1 1.7H1.8V.1C2.4 0 2.9 0 3.5 0zM14.1 1.7v-.2c-.1-.6-.5-1-1-1.3-.2-.1-.4-.2-.6-.2h1.7c-.1.6-.1 1.2-.1 1.7z"/><path d="M9.8 3.4v-.9c0-.3.2-.6.5-.6h1.3c.3 0 .5.2.6.5v2c0 .3-.2.5-.5.6h-1.3c-.3 0-.6-.2-.6-.5v-.1-1zm1.8.9V2.5h-1.2v1.8h1.2z"/><path d="M11.6 4.3h-1.2V2.5h1.2v1.8z"/>';
					break;

				case 'check' :

					$return_value = '<path d="M7.3 14.2l-7.1-5.2 1.7-2.4 4.8 3.5 6.6-8.5 2.3 1.8z"/>';
					break;

				case 'checkbox' :

					$return_value = '<path d="M14 6.2v7.8h-12v-12h10.5l1-1h-12.5v14h14v-9.8z"/><path d="M7.9 10.9l-4.2-4.2 1.5-1.4 2.7 2.8 6.7-6.7 1.4 1.4z"/>';
					break;

				case 'clear' :

					$return_value = '<path d="M8.1 14l6.4-7.2c0.6-0.7 0.6-1.8-0.1-2.5l-2.7-2.7c-0.3-0.4-0.8-0.6-1.3-0.6h-1.8c-0.5 0-1 0.2-1.4 0.6l-6.7 7.6c-0.6 0.7-0.6 1.9 0.1 2.5l2.7 2.7c0.3 0.4 0.8 0.6 1.3 0.6h11.4v-1h-7.9zM6.8 13.9c0 0 0-0.1 0 0l-2.7-2.7c-0.4-0.4-0.4-0.9 0-1.3l3.4-3.9h-1l-3 3.3c-0.6 0.7-0.6 1.7 0.1 2.4l2.3 2.3h-1.3c-0.2 0-0.4-0.1-0.6-0.2l-2.8-2.8c-0.3-0.3-0.3-0.8 0-1.1l3.5-3.9h1.8l3.5-4h1l-3.5 4 3.1 3.7-3.5 4c-0.1 0.1-0.2 0.1-0.3 0.2z"/>';
					break;

				case 'clone' :

					$return_value = '<path d="M14.5 0h-10A1.5 1.5 0 003 1.5V3H1.5A1.5 1.5 0 000 4.5v10A1.5 1.5 0 001.5 16h10a1.5 1.5 0 001.5-1.5V13h1.5a1.5 1.5 0 001.5-1.5v-10A1.5 1.5 0 0014.5 0zm-3.188 14.5H1.688a.187.187 0 01-.188-.188V4.688c0-.104.084-.188.188-.188H3v7A1.5 1.5 0 004.5 13h7v1.313a.187.187 0 01-.188.187zm3-3H4.688a.187.187 0 01-.188-.188V1.688c0-.104.084-.188.188-.188h9.625c.103 0 .187.084.187.188v9.624a.187.187 0 01-.188.188z" id="Shape" transform="matrix(1 0 0 -1 0 16)"/>';
					break;

				case 'color' :

					$return_value = '<path d="M15 1c-1.8-1.8-3.7-0.7-4.6 0.1-0.4 0.4-0.7 0.9-0.7 1.5v0c0 1.1-1.1 1.8-2.1 1.5l-0.1-0.1-0.7 0.8 0.7 0.7-6 6-0.8 2.3-0.7 0.7 1.5 1.5 0.8-0.8 2.3-0.8 6-6 0.7 0.7 0.7-0.6-0.1-0.2c-0.3-1 0.4-2.1 1.5-2.1v0c0.6 0 1.1-0.2 1.4-0.6 0.9-0.9 2-2.8 0.2-4.6zM3.9 13.6l-2 0.7-0.2 0.1 0.1-0.2 0.7-2 5.8-5.8 1.5 1.5-5.9 5.7z"/>';
					break;

				case 'conditional' :

					$return_value = '<path d="M14 13v-1c0-0.2 0-4.1-2.8-5.4-2.2-1-2.2-3.5-2.2-3.6v-3h-2v3c0 0.1 0 2.6-2.2 3.6-2.8 1.3-2.8 5.2-2.8 5.4v1h-2l3 3 3-3h-2v-1c0 0 0-2.8 1.7-3.6 1.1-0.5 1.8-1.3 2.3-2 0.5 0.8 1.2 1.5 2.3 2 1.7 0.8 1.7 3.6 1.7 3.6v1h-2l3 3 3-3h-2z" transform="translate(8.000000, 8.000000) rotate(-180.000000) translate(-8.000000, -8.000000)"/>';
					break;

				case 'contract' :

					$return_value = '<path d="M12 0h-12v12l1-1v-10h10z"/><path d="M4 16h12v-12l-1 1v10h-10z"/><path d="M7 9h-5l1.8 1.8-3.8 3.8 1.4 1.4 3.8-3.8 1.8 1.8z"/><path d="M16 1.4l-1.4-1.4-3.8 3.8-1.8-1.8v5h5l-1.8-1.8z"/>';
					break;

				case 'datetime' :

					$return_value = '<path d="M3 0h1v3h-1v-3z"/><path d="M11 0h1v3h-1v-3z"/><path d="M6.6 14h-5.6v-8h13v0.6c0.4 0.2 0.7 0.4 1 0.7v-6.3h-2v3h-3v-3h-5v3h-3v-3h-2v14h7.3c-0.3-0.3-0.5-0.6-0.7-1z"/><path d="M14 12h-3v-3h1v2h2z"/><path d="M11.5 8c1.9 0 3.5 1.6 3.5 3.5s-1.6 3.5-3.5 3.5-3.5-1.6-3.5-3.5 1.6-3.5 3.5-3.5zM11.5 7c-2.5 0-4.5 2-4.5 4.5s2 4.5 4.5 4.5 4.5-2 4.5-4.5-2-4.5-4.5-4.5v0z"/>';
					break;

				case 'delete' :

					$return_value = '<path d="M15.1 3.1l-2.2-2.2-4.9 5-4.9-5-2.2 2.2 5 4.9-5 4.9 2.2 2.2 4.9-5 4.9 5 2.2-2.2-5-4.9z"/>';
					break;

				case 'delete-circle' :

					$return_value = '<path d="M8,0 C3.6,0 0,3.6 0,8 C0,12.4 3.6,16 8,16 C12.4,16 16,12.4 16,8 C16,3.6 12.4,0 8,0 Z"/><polygon fill="#FFFFFF" points="12.2 10.8 10.8 12.2 8 9.4 5.2 12.2 3.8 10.8 6.6 8 3.8 5.2 5.2 3.8 8 6.6 10.8 3.8 12.2 5.2 9.4 8 12.2 10.8"></polygon>';
					break;

				case 'disabled' :

					$return_value = '<path d="M8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zM8 2c1.3 0 2.5 0.4 3.5 1.1l-8.4 8.4c-0.7-1-1.1-2.2-1.1-3.5 0-3.3 2.7-6 6-6zM8 14c-1.3 0-2.5-0.4-3.5-1.1l8.4-8.4c0.7 1 1.1 2.2 1.1 3.5 0 3.3-2.7 6-6 6z"/>';
					break;

				case 'divider' :

					$return_value = '<path d="M0 7.38h16v1.44H0z"/>';
					break;

				case 'down' :

					$return_value = '<path d="M15 3H1l7 10 7-10z"/>';
					break;

				case 'download' :

					$return_value = '<path d="M12,9h3V0L1,0v9h3V8H2V1h12v7h-2V9z"/><path d="M8,16l4-5h-2V6H6v5H4L8,16z"/>';
					break;

				case 'edit' :

					$return_value = '<path d="M16 9v-2l-1.7-0.6c-0.2-0.6-0.4-1.2-0.7-1.8l0.8-1.6-1.4-1.4-1.6 0.8c-0.5-0.3-1.1-0.6-1.8-0.7l-0.6-1.7h-2l-0.6 1.7c-0.6 0.2-1.2 0.4-1.7 0.7l-1.6-0.8-1.5 1.5 0.8 1.6c-0.3 0.5-0.5 1.1-0.7 1.7l-1.7 0.6v2l1.7 0.6c0.2 0.6 0.4 1.2 0.7 1.8l-0.8 1.6 1.4 1.4 1.6-0.8c0.5 0.3 1.1 0.6 1.8 0.7l0.6 1.7h2l0.6-1.7c0.6-0.2 1.2-0.4 1.8-0.7l1.6 0.8 1.4-1.4-0.8-1.6c0.3-0.5 0.6-1.1 0.7-1.8l1.7-0.6zM8 12c-2.2 0-4-1.8-4-4s1.8-4 4-4 4 1.8 4 4-1.8 4-4 4z"/><path d="M10.6 7.9c0 1.381-1.119 2.5-2.5 2.5s-2.5-1.119-2.5-2.5c0-1.381 1.119-2.5 2.5-2.5s2.5 1.119 2.5 2.5z"/>';
					break;

				case 'email' :

					$return_value = '<path d="M0 3h16v2.4l-8 4-8-4z"/><path d="M0 14l5.5-4.8 2.5 1.4 2.5-1.4 5.5 4.8z"/><path d="M4.6 8.8l-4.6-2.3v6.5z"/><path d="M11.4 8.8l4.6-2.3v6.5z"/>';
					break;

				case 'exchange' :

					$return_value = '<path d="M16 5v2h-13v2l-3-3 3-3v2z"/><path d="M0 12v-2h13v-2l3 3-3 3v-2z"/>';
					break;

				case 'expand' :

					$return_value = '<path d="M11 2h-9v9l1-1v-7h7z"/><path d="M5 14h9v-9l-1 1v7h-7z"/><path d="M16 0h-5l1.8 1.8-4.5 4.5 1.4 1.4 4.5-4.5 1.8 1.8z"/><path d="M7.7 9.7l-1.4-1.4-4.5 4.5-1.8-1.8v5h5l-1.8-1.8z"/>';
					break;

				case 'file' :

					$return_value = '<path d="M2.7 15.3c-0.7 0-1.4-0.3-1.9-0.8-0.9-0.9-1.2-2.5 0-3.7l8.9-8.9c1.4-1.4 3.8-1.4 5.2 0s1.4 3.8 0 5.2l-7.4 7.4c-0.2 0.2-0.5 0.2-0.7 0s-0.2-0.5 0-0.7l7.4-7.4c1-1 1-2.7 0-3.7s-2.7-1-3.7 0l-8.9 8.9c-0.8 0.8-0.6 1.7 0 2.2 0.6 0.6 1.5 0.8 2.2 0l8.9-8.9c0.2-0.2 0.2-0.5 0-0.7s-0.5-0.2-0.7 0l-7.4 7.4c-0.2 0.2-0.5 0.2-0.7 0s-0.2-0.5 0-0.7l7.4-7.4c0.6-0.6 1.6-0.6 2.2 0s0.6 1.6 0 2.2l-8.9 8.9c-0.6 0.4-1.3 0.7-1.9 0.7z"/>';
					break;

				case 'file-code' :

					$return_value = '<path d="M10 0h-8v16h12v-12l-4-4zM9 5h4v10h-10v-14h6v4zM10 4v-3l3 3h-3z"/><path d="M6.2 13h-0.7l-2-2.5 2-2.5h0.7l-2 2.5z"/><path d="M9.8 13h0.7l2-2.5-2-2.5h-0.7l2 2.5z"/><path d="M6.7 14h0.6l2.1-7h-0.8z"/>';
					break;

				case 'file-default' :

					$return_value = '<path d="M10 0h-8v16h12v-12l-4-4zM9 5h4v10h-10v-14h6v4zM10 4v-3l3 3h-3z"/>';
					break;

				case 'file-font' :

					$return_value = '<path d="M10 0h-8v16h12v-12l-4-4zM9 5h4v10h-10v-14h6v4zM10 4v-3l3 3h-3z"/><path d="M5 7v2h2v5h2v-5h2v-2z"/>';
					break;

				case 'file-movie' :

					$return_value = '<path d="M10 0h-8v16h12v-12l-4-4zM9 5h4v10h-10v-14h6v4zM10 4v-3l3 3h-3z"/><path d="M10 10v-2h-6v5h6v-2l2 2v-5z"/>';
					break;

				case 'file-picture' :

					$return_value = '<path d="M10 0h-8v16h12v-12l-4-4zM9 5h4v10h-10v-14h6v4zM10 4v-3l3 3h-3z"/><path d="M4 11.5v2.5h8v-1.7c0 0 0.1-1.3-1.3-1.5-1.3-0.2-1.5 0.4-2.5 0.5-0.8 0-0.6-1.3-2.2-1.3-1.2 0-2 1.5-2 1.5z"/><path d="M12 8.5c0 0.828-0.672 1.5-1.5 1.5s-1.5-0.672-1.5-1.5c0-0.828 0.672-1.5 1.5-1.5s1.5 0.672 1.5 1.5z"/>';
					break;

				case 'file-presentation' :

					$return_value = '<path d="M10 0h-8v16h12v-12l-4-4zM13 15h-10v-14h6v4h4v10zM10 4v-3l3 3h-3z"/><path d="M9 6h-2v1h-3v6h2v1h1v-1h2v1h1v-1h2v-6h-3v-1zM11 8v4h-6v-4h6z"/><path d="M7 9v2l2-1z"/>';
					break;

				case 'file-sound' :

					$return_value = '<path d="M11.4 10.5c0 1.2-0.4 2.2-1 3l0.4 0.5c0.7-0.9 1.2-2.1 1.2-3.5s-0.5-2.6-1.2-3.5l-0.4 0.5c0.6 0.8 1 1.9 1 3z"/><path d="M9.9 8l-0.4 0.5c0.4 0.5 0.7 1.2 0.7 2s-0.3 1.5-0.7 2l0.4 0.5c0.5-0.6 0.8-1.5 0.8-2.5s-0.3-1.8-0.8-2.5z"/><path d="M9.1 9l-0.4 0.5c0.2 0.3 0.3 0.6 0.3 1s-0.1 0.7-0.3 1l0.4 0.5c0.3-0.4 0.5-0.9 0.5-1.5s-0.2-1.1-0.5-1.5z"/><path d="M10 0h-8v16h12v-12l-4-4zM9 5h4v10h-10v-14h6v4zM10 4v-3l3 3h-3z"/><path d="M6 9h-2v3h2l2 2v-7z"/>';
					break;

				case 'file-table' :

					$return_value = '<path d="M10 0h-8v16h12v-12l-4-4zM9 5h4v10h-10v-14h6v4zM10 4v-3l3 3h-3z"/><path d="M4 7v6h8v-6h-8zM6 12h-1v-1h1v1zM6 10h-1v-1h1v1zM9 12h-2v-1h2v1zM9 10h-2v-1h2v1zM11 12h-1v-1h1v1zM11 10h-1v-1h1v1z"/>';
					break;

				case 'file-text' :

					$return_value = '<path d="M10 0h-8v16h12v-12l-4-4zM9 5h4v10h-10v-14h6v4zM10 4v-3l3 3h-3z"/><path d="M4 7h8v1h-8v-1z"/><path d="M4 9h8v1h-8v-1z"/><path d="M4 11h8v1h-8v-1z"/>';
					break;

				case 'file-zip' :

					$return_value = '<path d="M10 0h-8v16h12v-12l-4-4zM9 15h-4v-2.8l0.7-2.2h2.4l0.9 2.2v2.8zM13 15h-3v-3l-1-3h-2v-1h-2v1l-1 3v3h-1v-14h4v1h2v1h-2v1h2v1h4v10zM10 4v-3l3 3h-3z"/><path d="M5 6h2v1h-2v-1z"/><path d="M5 2h2v1h-2v-1z"/><path d="M5 4h2v1h-2v-1z"/><path d="M7 5h2v1h-2v-1z"/><path d="M7 7h2v1h-2v-1z"/><path d="M6 12h2v2h-2v-2z"/>';
					break;

				case 'first' :

					$return_value = '<path d="M14 15v-14l-10 7z"/><path d="M2 1h2v14h-2v-14z"/>';
					break;

				case 'googlemap' :

					$return_value = '<path d="M8 0c-2.8 0-5 2.2-5 5s4 11 5 11c1 0 5-8.2 5-11s-2.2-5-5-5zM8 8c-1.7 0-3-1.3-3-3s1.3-3 3-3 3 1.3 3 3-1.3 3-3 3z"/>';
					break;

				case 'group' :

					$return_value = '<path d="M14 4v-2h-14v12h16v-10h-2zM10 3h3v1h-3v-1zM6 3h3v1h-3v-1zM15 13h-14v-10h4v2h10v8z"/>';
					break;

				case 'hcaptcha' :

					$return_value = '<path d="m3.1 7 1-2.2c.3-.6.3-1.3-.1-1.7-.1 0-.1-.1-.2-.1-.2-.2-.6-.2-.9-.1-.3.1-.6.3-.8.6 0 0-1.4 3.2-1.9 4.6s-.3 4 1.6 6c2.1 2.1 5 2.5 6.9 1.1.2-.1.3-.1.3-.2l5.9-4.9c.3-.2.7-.7.3-1.3-.4-.5-1.1-.2-1.4 0l-3.4 2.5c-.1.1-.2 0-.2 0-.1-.1-.1-.4 0-.5l5.2-4.4c.5-.4.6-1 .2-1.4-.4-.4-.9-.4-1.4 0L9.6 8.7c-.1.1-.2.1-.3 0-.1-.1-.1-.3 0-.4l5.3-5.1c.4-.4.4-1 .1-1.5-.2-.2-.4-.3-.7-.3-.3 0-.5.1-.7.3L7.8 6.8c-.1.1-.4 0-.4-.2v-.2l4.1-4.7c.4-.4.4-1 .1-1.4s-1-.4-1.4-.1l-6.4 7c-.2.3-.5.3-.7.1-.1 0-.1-.2 0-.3z"/>';
					break;

				case 'hidden' :

					$return_value = '<path d="M12.9 5.2l-0.8 0.8c1.7 0.9 2.5 2.3 2.8 3-0.7 0.9-2.8 3.1-7 3.1-0.7 0-1.2-0.1-1.8-0.2l-0.8 0.8c0.8 0.3 1.7 0.4 2.6 0.4 5.7 0 8.1-4 8.1-4s-0.6-2.4-3.1-3.9z"/><path d="M12 7.1c0-0.3 0-0.6-0.1-0.8l-4.8 4.7c0.3 0 0.6 0.1 0.9 0.1 2.2 0 4-1.8 4-4z"/><path d="M15.3 0l-4.4 4.4c-0.8-0.2-1.8-0.4-2.9-0.4-6.7 0-8 5.1-8 5.1s1 1.8 3.3 3l-3.3 3.2v0.7h0.7l15.3-15.3v-0.7h-0.7zM4 11.3c-1.6-0.7-2.5-1.8-2.9-2.3 0.3-0.7 1.1-2.2 3.1-3.2-0.1 0.4-0.2 0.8-0.2 1.3 0 1.1 0.5 2.2 1.3 2.9l-1.3 1.3zM6.2 7.9l-1 0.2c0 0-0.3-0.5-0.3-1.2 0-0.8 0.4-1.5 0.4-1.5 0.5-0.3 1.3-0.3 1.3-0.3s-0.5 0.9-0.5 1.7c-0.1 0.7 0.1 1.1 0.1 1.1z"/>';
					break;

				case 'html' :

					$return_value = '<path d="M5.2 14l4.5-12h1.1l-4.5 12z"/><path d="M11.1 13h1.2l3.7-5-3.7-5h-1.3l3.8 5z"/><path d="M4.9 13h-1.2l-3.7-5 3.7-5h1.3l-3.8 5z"/>';
					break;

				case 'info-circle' :

					$return_value = '<path d="M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm1 13H7V6h2v7zm0-8H7V3h2v2z"/>';
					break;

				case 'last' :

					$return_value = '<path d="M2 1v14l10-7z"/><path d="M12 1h2v14h-2v-14z"/>';
					break;

				case 'legal' :

					$return_value = '<path d="M5.2 5.3c.5 1 .9 2 1.4 3.1-.1 0-.2-.1-.3-.1-.4-.1-.7-.2-1-.3-.1 0-.1 0-.2.1-.2.3-.3.7-.5 1.1 0 0 0 .1-.1.1-.4-.9-.8-1.7-1.2-2.6-.4.9-.8 1.7-1.2 2.6l-.3-.6-.3-.6C1.4 8 1.4 8 1.3 8l-1.2.3H0c.5-1 1-2 1.4-3.1-.1 0-.1-.1-.2-.1-.3-.1-.5-.3-.5-.7 0-.3-.1-.6-.3-.8-.2-.3-.2-.6 0-.9.2-.3.3-.6.3-1 0-.3.2-.5.4-.6.4-.1.7-.3.9-.6.2-.2.5-.3.7-.2.4.1.7.1 1.1 0 .3-.1.5 0 .7.2.2.3.5.5.8.6.3.1.5.4.5.7 0 .3.1.6.3.8.1.1.1.2.1.3.1.2.1.3 0 .5 0 .1-.1.2-.1.3-.1.2-.2.4-.2.7v.3c0 .2-.2.4-.4.5-.1 0-.2 0-.3.1zm-.1-2.2c0-1-.8-1.9-1.8-1.9-1.1 0-1.9.8-1.9 1.9 0 1 .8 1.9 1.8 1.9 1.1 0 1.9-.9 1.9-1.9zM2.8 9.2c-.1.2-.2.5-.2.8v5.6h9.8v-3.9c-.4.4-.7.8-1.1 1.2V14.4H3.9V14 9.3v-.1c-.3-.4-.4-.7-.6-1.1-.2.4-.3.7-.5 1.1zm6.2 2l1.4 1.4c1.6-1.6 3.2-3.3 4.8-4.9l-1.4-1.4C12.2 8 10.6 9.6 9 11.2zm2.3-3.5l1-1c.1-.1.1-.1.1-.2V2.3v-.1H6.6c.1.2.2.4.2.6.1.2 0 .4.1.6h4.3c0 1.4 0 2.9.1 4.3zm-6.2 3.4h3.2s.1 0 .1-.1c.3-.3.7-.6 1-.9.1-.1.1-.1.2-.1H5.1c-.1.3-.1.7 0 1.1zM6.6 5v1.2H10V5H6.6zm.2 2.6c.1.3.3.7.4 1 0 .1.1.1.1.1h2.6V7.5c-1 0-2 0-3.1.1zm8.7-.3c.1-.1.3-.2.4-.4.2-.2.1-.4 0-.6l-.8-.8c-.1-.1-.4-.2-.5 0l-.4.4c.4.5.9 1 1.3 1.4zm-7.1 5.1c0 .1 0 .1 0 0 .2.3.4.5.6.7h.1c.3-.1.6-.1.8-.2-.4-.5-.9-.9-1.3-1.4-.1.4-.1.6-.2.9zm-.2 1c.3-.1.5-.1.7-.2-.2-.2-.4-.4-.5-.6-.1.3-.2.5-.2.8z"/>';
					break;

				case 'markup-circle' :

					$return_value = '<path d="M8 0C3.6 0 0 3.6 0 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zM6.3 6.2L3.3 8l3 1.8v1.9L1.9 8.8V7.2l4.3-2.9v1.9zM7.6 13h-.9L8.3 3h.9L7.6 13zm2-1.3V9.8l3-1.8-3-1.8V4.3L14 7.2v1.6l-4.4 2.9z"/>';
					break;

				case 'menu' :

					$return_value = '<path d="M0 1h16v3h-16v-3z"/><path d="M0 6h16v3h-16v-3z"/><path d="M0 11h16v3h-16v-3z"/>';
					break;

				case 'minus' :

					$return_value = '<path d="M2 7h12v2h-12v-2z"/>';
					break;

				case 'minus-circle' :

					$return_value = '<path d="M8,0 C3.6,0 0,3.6 0,8 C0,12.4 3.6,16 8,16 C12.4,16 16,12.4 16,8 C16,3.6 12.4,0 8,0 Z"/><polygon fill="#FFFFFF" points="13 9 3 9 3 7 13 7"></polygon>';
					break;

				case 'next' :

					$return_value = '<path d="M3 1v14l10-7L3 1z"/>';
					break;

				case 'note' :

					$return_value = '<path d="M11.9 6.6s.6-.5.2-1c-.5-.5-1 .1-1 .1l-5 5s-1.2 1.5-2 .6c-.9-.9.6-2 .6-2l6.5-6.5s1.5-1.7 2.9-.2c1.4 1.4-.3 2.9-.3 2.9l-7.3 7.3s-2.3 2.7-4.5.5.6-4.5.6-4.5l5.5-5.5s.6-.5.2-1c-.5-.5-1 .2-1 .2L1 8.8s-2.4 2.6.3 5.3c2.7 2.7 5.3.3 5.3.3l8.7-8.7s1.7-1.9-.3-4-4-.3-4-.3L3.5 8.8s-1.9 1.6-.2 3.3c1.7 1.7 3.3-.2 3.3-.2l5.3-5.3z"/>';
					break;

				case 'number' :

					$return_value = '<path d="M15 6v-2h-2.6l0.6-2.8-2-0.4-0.7 3.2h-3l0.7-2.8-2-0.4-0.7 3.2h-3.3v2h2.9l-0.9 4h-3v2h2.6l-0.6 2.8 2 0.4 0.7-3.2h3l-0.7 2.8 2 0.4 0.7-3.2h3.3v-2h-2.9l0.9-4h3zM9 10h-3l1-4h3l-1 4z"/>';
					break;

				case 'password' :

					$return_value = '<path d="M16 5c0-0.6-0.4-1-1-1h-14c-0.6 0-1 0.4-1 1v6c0 0.6 0.4 1 1 1h14c0.6 0 1-0.4 1-1v-6zM15 11h-14v-6h14v6z"/><path d="M6 8c0 0.552-0.448 1-1 1s-1-0.448-1-1c0-0.552 0.448-1 1-1s1 0.448 1 1z"/><path d="M9 8c0 0.552-0.448 1-1 1s-1-0.448-1-1c0-0.552 0.448-1 1-1s1 0.448 1 1z"/><path d="M12 8c0 0.552-0.448 1-1 1s-1-0.448-1-1c0-0.552 0.448-1 1-1s1 0.448 1 1z"/>';
					break;

				case 'picture' :

					$return_value = '<path d="M16 14h-16v-12h16v12zM1 13h14v-10h-14v10z"/><path d="M2 10v2h12v-1c0 0 0.2-1.7-2-2-1.9-0.3-2.2 0.6-3.8 0.6-1.1 0-0.9-1.6-3.2-1.6-1.7 0-3 2-3 2z"/><path d="M13 6c0 1.105-0.895 2-2 2s-2-0.895-2-2c0-1.105 0.895-2 2-2s2 0.895 2 2z"/>';
					break;

				case 'plus' :

					$return_value = '<path d="M14 7h-5v-5h-2v5h-5v2h5v5h2v-5h5v-2z"/>';
					break;

				case 'plus-circle' :

					$return_value = '<path d="M8,0 C3.6,0 0,3.6 0,8 C0,12.4 3.6,16 8,16 C12.4,16 16,12.4 16,8 C16,3.6 12.4,0 8,0 Z"/><polygon fill="#FFFFFF" points="13 9 9 9 9 13 7 13 7 9 3 9 3 7 7 7 7 3 9 3 9 7 13 7"></polygon>';
					break;

				case 'previous' :

					$return_value = '<path d="M14 15V1L4 8z"/>';
					break;

				case 'price' :

					$return_value = '<path d="M5.6 16h-.2c-.2 0-.3-.1-.5-.3l-1.3-1.3-3.3-3.3c-.1-.2-.3-.4-.3-.6 0-.3.1-.6.3-.9l.1-.1C2.6 7.2 4.9 5 7.1 2.7c.1-.1.2-.1.3-.1h2.5v.3c0 .2 0 .4.1.6-.1.3 0 .5 0 .7-.2.3-.2.5-.2.8 0 .6.5 1.1 1.1 1.2.4.1.8 0 1.1-.4.3-.3.4-.6.4-1s-.2-.7-.5-1v-.1c0-.2-.1-.4-.1-.6v-.5h.2c.2 0 .4 0 .5.1.1 0 .3.1.4.1.1.2.2.2.2.4s.1.3.1.5.1.4.1.7c0 .2 0 .4.1.6 0 .2 0 .4.1.6V8.2c0 .2 0 .4-.1.5 0 .1-.1.1-.1.2l-6.8 6.8c-.2.2-.4.3-.7.3h-.2z"/><path d="M16 3.2c0 .3 0 .7-.1 1-.1.9-.4 1.8-.7 2.6-.1.2-.2.3-.3.5-.1.2-.2.3-.4.3s-.3-.1-.4-.2c-.1-.2-.1-.4 0-.5.3-.5.5-1.1.7-1.7.1-.3.1-.6.2-1 0-.4.1-.8 0-1.2 0-.4-.1-.8-.4-1.2-.2-.5-.6-.7-1.1-.8-.4-.1-.8 0-1.1.1-.6.3-.9.7-1.1 1.3-.1.2-.1.5 0 .7 0 .3.1.6.1.8 0 .3.1.6.2.9.1.3-.1.6-.4.6-.2 0-.4-.1-.5-.4-.1-.3-.1-.7-.2-1-.1-.4-.1-.7-.1-1.1 0-.7.2-1.3.6-1.8.4-.5.8-.8 1.4-1 .3-.1.6-.1.9-.1.8 0 1.4.4 1.9.9.4.4.6.9.7 1.5.1.3.1.5.1.8z"/>';
					break;

				case 'progress' :
				case 'meter' :

					$return_value = '<path d="M0 5v6h16v-6h-16zM15 10h-14v-4h14v4z"/><path d="M2 7h7v2h-7v-2z"/>';
					break;

				case 'publish' :

					$return_value = '<path d="M14.1 10.9c0-0.2 0-0.4 0-0.6 0-2.4-1.9-4.3-4.2-4.3-0.3 0-0.6 0-0.9 0.1v-2.1h2l-3-4-3 4h2v1.5c-0.4-0.2-0.9-0.3-1.3-0.3-1.6 0-2.9 1.2-2.9 2.8 0 0.3 0.1 0.6 0.2 0.9-1.6 0.2-3 1.8-3 3.5 0 1.9 1.5 3.6 3.3 3.6h10.3c1.4 0 2.4-1.4 2.4-2.6s-0.8-2.2-1.9-2.5zM13.6 15h-10.3c-1.2 0-2.3-1.2-2.3-2.5s1.1-2.5 2.3-2.5c0.1 0 0.3 0 0.4 0l1.3 0.3-0.8-1.2c-0.2-0.3-0.4-0.7-0.4-1.1 0-1 0.8-1.8 1.8-1.8 0.5 0 1 0.2 1.3 0.6v3.2h2v-2.8c0.3-0.1 0.6-0.1 0.9-0.1 1.8 0 3.2 1.5 3.2 3.3 0 0.3 0 0.6-0.1 0.9l-0.2 0.6h0.8c0.7 0 1.4 0.7 1.4 1.5 0.1 0.7-0.5 1.6-1.3 1.6z"/>';
					break;

				case 'quantity' :

					$return_value = '<path d="M16 5.2c0 .2-.1.3-.1.5-.4 1.7-1.9 2.8-3.6 2.7-1.7-.1-3-1.3-3.2-3-.3-2 1.1-3.8 3.1-4 1.8-.1 3.5 1.2 3.8 3.2v.6zm-4 .3v1.1c0 .3.1.4.4.4h.3c.2 0 .3-.1.3-.4V5.5h1.2c.3 0 .4-.1.4-.4v-.3c0-.3-.1-.4-.4-.4h-1.1v-.2-1c-.1-.1-.2-.2-.4-.2h-.4c-.2 0-.3 0-.3.3v1.1h-1.2c-.2 0-.3.1-.3.3V5c0 .3.1.3.3.3.4.2.8.2 1.2.2z"/><path d="M11.8 9.2c.3 0 .7 0 1 .1-.1.4-.2.7-.3 1.1-.1.5-.2.6-.8.6H4c-.3.1-.5.4-.5.7 0 .3.3.6.6.6 0 0 0-.1.1-.1.3-.5.7-.8 1.4-.8.6 0 1 .3 1.3.9.1.1.1.1.2.1H9c.1 0 .1 0 .2-.1.3-.6.7-.9 1.4-.9.6 0 1.1.3 1.4.9 0 .1.1.1.2.1h.5c.3 0 .5.2.5.5s-.2.5-.5.5h-.5c-.1 0-.2 0-.2.1-.5 1-1.7 1.2-2.5.4-.1-.1-.2-.2-.2-.4 0-.1-.1-.1-.2-.1h-2c-.1 0-.1 0-.1.1-.3.6-.7.9-1.4.9-.6 0-1.1-.3-1.3-.9 0-.1-.1-.1-.2-.1-.7-.2-1.3-.7-1.4-1.4-.1-.8.3-1.6 1.1-1.9.1 0 .1 0 .2-.1-.3-.4-.4-.8-.6-1.3C2.9 6.9 2.3 5 1.7 3.1c0-.1-.1-.2-.2-.2-.4.1-.7.1-1 .1-.3-.1-.5-.3-.5-.5 0-.3.2-.5.5-.5h1.4c.3 0 .5.1.5.4.2.5.3 1 .4 1.4.2.1.2.2.3.2h5.2c0 .3-.1.7-.1 1H7v1h1.3c.1.3.2.7.4 1H7v1H9.6c.4.4.9.7 1.4.9h.1-.5v1h1l.1-.1c0-.2.1-.4.1-.6zM6 5H3.3l.3.9s0 .1.1.1h2.2c.1-.4.1-.7.1-1zm1 5h2.5V9H7v1zM3.9 7c.1.3.2.5.3.8 0 .1.1.2.2.2H6V7H3.9zM6 10V9H4.7h-.1l.3.9.1.1h1zm.1 3c0-.3-.3-.6-.6-.6s-.6.3-.6.6.3.6.6.6c.3-.1.6-.3.6-.6zm5 0c0-.3-.3-.6-.6-.6s-.6.3-.6.6.3.6.6.6c.3-.1.6-.3.6-.6z"/>';
					break;

				case 'question-circle' :

					$return_value = '<path d="M8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zM8.9 13h-2v-2h2v2zM11 8.1c-0.4 0.4-0.8 0.6-1.2 0.7-0.6 0.4-0.8 0.2-0.8 1.2h-2c0-2 1.2-2.6 2-3 0.3-0.1 0.5-0.2 0.7-0.4 0.1-0.1 0.3-0.3 0.1-0.7-0.2-0.5-0.8-1-1.7-1-1.4 0-1.6 1.2-1.7 1.5l-2-0.3c0.1-1.1 1-3.2 3.6-3.2 1.6 0 3 0.9 3.6 2.2 0.4 1.1 0.2 2.2-0.6 3z"/>';
					break;

				case 'radio' :

					$return_value = '<path d="M8 4c-2.2 0-4 1.8-4 4s1.8 4 4 4 4-1.8 4-4-1.8-4-4-4z"/><path d="M8 1c3.9 0 7 3.1 7 7s-3.1 7-7 7-7-3.1-7-7 3.1-7 7-7zM8 0c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8v0z"/>';
					break;

				case 'range' :

					$return_value = '<path d="M16 6h-3.6c-0.7-1.2-2-2-3.4-2s-2.8 0.8-3.4 2h-5.6v4h5.6c0.7 1.2 2 2 3.4 2s2.8-0.8 3.4-2h3.6v-4zM1 9v-2h4.1c0 0.3-0.1 0.7-0.1 1s0.1 0.7 0.1 1h-4.1zM9 11c-1.7 0-3-1.3-3-3s1.3-3 3-3 3 1.3 3 3c0 1.7-1.3 3-3 3z"/>';
					break;

				case 'rating' :

					$return_value = '<path d="M12.9 15.8c-1.6-1.2-3.2-2.5-4.9-3.7-1.6 1.3-3.3 2.5-4.9 3.7 0 0-.1 0-.1-.1.6-2 1.2-4 1.9-6C3.3 8.4 1.7 7.2 0 5.9h6C6.7 3.9 7.3 2 8 0h.1c.7 1.9 1.3 3.9 2 5.9H16V6c-1.6 1.3-3.2 2.5-4.9 3.8.6 1.9 1.3 3.9 1.8 6 .1-.1 0 0 0 0z"/>';
					break;

				case 'readonly' :

					$return_value = '<path d="M12 8v-3.1c0-2.2-1.6-3.9-3.8-3.9h-0.3c-2.1 0-3.9 1.7-3.9 3.9v3.1h-1l0.1 5c0 0-0.1 3 4.9 3s5-3 5-3v-5h-1zM9 14h-1v-2c-0.6 0-1-0.4-1-1s0.4-1 1-1 1 0.4 1 1v3zM10 8h-4v-3.1c0-1.1 0.9-1.9 1.9-1.9h0.3c1 0 1.8 0.8 1.8 1.9v3.1z"/>';
					break;

				case 'recaptcha' :

					$return_value = '<path d="M15.9918286,7.6696 L15.9918286,1.19512381 L14.2019048,2.98504762 C12.9340679,1.4331632 11.0942831,0.36651433 9.00406542,0.107566742 L9.00625984,4.27593888 C9.94543519,4.53172702 10.7423473,5.13244509 11.2527238,5.93344381 L9.1759619,8.01020571 C11.8064381,7.9998819 14.7780571,7.99382476 15.9997714,8.01153905 C15.999619,7.89727238 15.9969714,7.7831619 15.9918286,7.6696 Z"/><path d="M7.62312381,0.0550285714 L1.14864762,0.0550285714 L2.93857143,1.84495238 C1.39662338,3.10467157 0.333717053,4.92903803 0.0661637514,7.00267304 L4.23979134,7.00341189 C4.50117426,6.08039453 5.09656172,5.29776041 5.88696762,4.79413333 L7.96372952,6.87089524 C7.95340571,4.24041905 7.94732952,1.2688 7.96506286,0.0470857143 C7.85079619,0.0472380952 7.73668571,0.0498857143 7.62312381,0.0550285714 Z"/><path d="M0.000380952381,8.03447619 C0.000761904762,8.14920381 0.00340952381,8.26331429 0.00855238095,8.37687619 L0.00855238095,14.8513524 L1.79847619,13.0614286 C3.26342857,14.8545905 5.492,15.9999048 7.98819048,15.9999048 C10.5859048,15.9999048 12.8937143,14.7599619 14.3525714,12.8397143 L11.4186667,9.87495238 C11.1311429,10.4067048 10.7226857,10.8634286 10.2301905,11.208381 C9.71798095,11.6080952 8.99222857,11.9349143 7.98828571,11.9349143 C7.8670019,11.9349143 7.77339048,11.9207429 7.70460952,11.8940419 C6.46072381,11.7958648 5.38251429,11.1093943 4.74765714,10.1130324 L6.82441905,8.03627048 C4.19394286,8.04659429 1.22232381,8.05265143 0.00060952381,8.03493714 L8.19047619,11.2380952"/>';
					break;

				case 'redo' :

					$return_value = '<path d="M16 7v-4l-1.1 1.1c-1.3-2.5-3.9-4.1-6.9-4.1-4.4 0-8 3.6-8 8s3.6 8 8 8c2.4 0 4.6-1.1 6-2.8l-1.5-1.3c-1.1 1.3-2.7 2.1-4.5 2.1-3.3 0-6-2.7-6-6s2.7-6 6-6c2.4 0 4.5 1.5 5.5 3.5l-1.5 1.5h4z"/><text class="count" font-size="7" line-spacing="7" x="50%" y="50%" dominant-baseline="middle" text-anchor="middle"></text>';
					break;

				case 'reload' :

					$return_value = '<path d="M2.6,5.6 C3.5,3.5 5.6,2 8,2 C11,2 13.4,4.2 13.9,7 L15.9,7 C15.4,3.1 12.1,0 8,0 C5,0 2.4,1.6 1.1,4.1 L-8.8817842e-16,3 L-8.8817842e-16,7 L4,7 L2.6,5.6 L2.6,5.6 Z" id="Shape" transform="translate(7.950000, 3.500000) scale(-1, 1) translate(-7.950000, -3.500000) "/><path d="M16,9 L11.9,9 L13.4,10.4 C12.5,12.5 10.4,14 7.9,14 C5,14 2.5,11.8 2,9 L0,9 C0.5,12.9 3.9,16 7.9,16 C10.9,16 13.5,14.3 14.9,11.9 L16,13 L16,9 Z" id="Shape" transform="translate(8.000000, 12.500000) scale(-1, 1) translate(-8.000000, -12.500000) "/>';
					break;

				case 'reset' :

					$return_value = '<path d="M8 0c-3 0-5.6 1.6-6.9 4.1l-1.1-1.1v4h4l-1.5-1.5c1-2 3.1-3.5 5.5-3.5 3.3 0 6 2.7 6 6s-2.7 6-6 6c-1.8 0-3.4-0.8-4.5-2.1l-1.5 1.3c1.4 1.7 3.6 2.8 6 2.8 4.4 0 8-3.6 8-8s-3.6-8-8-8z"/>';
					break;

				case 'save' :

					$return_value = '<path d="M15.791849,4.41655721 C15.6529844,4.08336982 15.4862083,3.8193958 15.2916665,3.625 L12.3749634,0.708260362 C12.1806771,0.513974022 11.916703,0.347234384 11.5833697,0.208260362 C11.2502188,0.0694322825 10.9445781,0 10.666849,0 L1.00003637,0 C0.722343724,0 0.486171803,0.0971614127 0.291703035,0.291630181 C0.0972342664,0.485989492 0.000109339408,0.722124927 0.000109339408,0.999963514 L0.000109339408,15.0002189 C0.000109339408,15.2781305 0.0972342664,15.5142659 0.291703035,15.7086617 C0.486171803,15.902948 0.722343724,16.0002189 1.00003637,16.0002189 L15.0002553,16.0002189 C15.2782033,16.0002189 15.5143023,15.902948 15.7086981,15.7086617 C15.9029844,15.5142659 16.0001093,15.2781305 16.0001093,15.0002189 L16.0001093,5.3334063 C16.0001093,5.05553123 15.9307135,4.75 15.791849,4.41655721 Z M6.66684898,1.66655721 C6.66684898,1.57629159 6.69986853,1.49832166 6.76587116,1.43220957 C6.83180082,1.36638938 6.90995318,1.3334063 7.0002188,1.3334063 L9.00032825,1.3334063 C9.09037496,1.3334063 9.16849083,1.3663164 9.23445698,1.43220957 C9.30060554,1.49832166 9.33358862,1.57629159 9.33358862,1.66655721 L9.33358862,4.99996351 C9.33358862,5.09037507 9.30038663,5.16845447 9.23445698,5.23445709 C9.16849083,5.30024081 9.09037496,5.33326036 9.00032825,5.33326036 L7.0002188,5.33326036 C6.90995318,5.33326036 6.83176433,5.30035026 6.76587116,5.23445709 C6.69986853,5.16834501 6.66684898,5.09037507 6.66684898,4.99996351 L6.66684898,1.66655721 Z M12.0003647,14.6669221 L4.00003637,14.6669221 L4.00003637,10.6667761 L12.0003647,10.6667761 L12.0003647,14.6669221 Z M14.6672503,14.6669221 L13.3336251,14.6669221 L13.3333697,14.6669221 L13.3333697,10.3334063 C13.3333697,10.0554947 13.2362083,9.81950525 13.0418125,9.62496351 C12.8474167,9.43056772 12.6112813,9.33329685 12.3336251,9.33329685 L3.66673952,9.33329685 C3.38893742,9.33329685 3.1527655,9.43056772 2.95829673,9.62496351 C2.76393742,9.81935931 2.66670303,10.0554947 2.66670303,10.3334063 L2.66670303,14.6669221 L1.33333322,14.6669221 L1.33333322,1.33326036 L2.66666655,1.33326036 L2.66666655,5.66670315 C2.66666655,5.94454174 2.76379148,6.18056772 2.95826024,6.37503649 C3.15272901,6.5693958 3.38890093,6.66666667 3.66670303,6.66666667 L9.66699492,6.66666667 C9.94465108,6.66666667 10.1810419,6.5693958 10.3751823,6.37503649 C10.5694687,6.18067717 10.666849,5.94454174 10.666849,5.66670315 L10.666849,1.33326036 C10.7709792,1.33326036 10.9063046,1.36792177 11.0731537,1.43735406 C11.2399663,1.50674985 11.3579611,1.57618214 11.4273933,1.64561442 L14.3547138,4.57286194 C14.4241096,4.64229422 14.4935784,4.76222271 14.5629742,4.93228255 C14.6326254,5.10248832 14.6672138,5.23620841 14.6672138,5.3334063 L14.6672138,14.6669221 L14.6672503,14.6669221 Z"/>';
					break;

				case 'search' :

					$return_value = '<path d="M10.7 1.8C8.3-.6 4.3-.6 1.8 1.8c-2.4 2.4-2.4 6.4 0 8.9 2.2 2.2 5.2 2.6 7.7.9.1.2.5.3.7.5l3.6 3.6c.5.5 1.4.5 1.9 0s.5-1.4 0-1.9l-3.6-3.6c-.2-.2-.2-.6-.5-.6 1.7-2.5 1.3-5.6-.9-7.8zM9.6 9.6c-1.8 1.8-4.8 1.8-6.6 0C1.1 7.7 1.1 4.8 3 3c1.8-1.8 4.8-1.8 6.6 0 1.8 1.8 1.8 4.7 0 6.6z"/>';
					break;

				case 'section' :

					$return_value = '<path d="M0 1.8h1.8V0C.8 0 0 .8 0 1.8zm0 7.1h1.8V7.1H0v1.8zM3.6 16h1.8v-1.8H3.6V16zM0 5.3h1.8V3.6H0v1.7zM8.9 0H7.1v1.8h1.8V0zm5.3 0v1.8H16c0-1-.8-1.8-1.8-1.8zM1.8 16v-1.8H0c0 1 .8 1.8 1.8 1.8zM0 12.4h1.8v-1.8H0v1.8zM5.3 0H3.6v1.8h1.8V0zm1.8 16h1.8v-1.8H7.1V16zm7.1-7.1H16V7.1h-1.8v1.8zm0 7.1c1 0 1.8-.8 1.8-1.8h-1.8V16zm0-10.7H16V3.6h-1.8v1.7zm0 7.1H16v-1.8h-1.8v1.8zM10.7 16h1.8v-1.8h-1.8V16zm0-14.2h1.8V0h-1.8v1.8z"/>';
					break;

				case 'section-icons' :

					$return_value = '<path d="M11.5 16c-1.2 0-2.3-.5-3.2-1.3S7 12.7 7 11.5s.5-2.3 1.3-3.2 2-1.3 3.2-1.3 2.3.5 3.2 1.3 1.3 2 1.3 3.2-.5 2.3-1.3 3.2-2 1.3-3.2 1.3zm0-8.3c-2.1 0-3.8 1.7-3.8 3.8s1.7 3.8 3.8 3.8 3.8-1.7 3.8-3.8-1.7-3.8-3.8-3.8zm1.9 3.4H9.6v.7h3.9v-.7zM7.7 1.3C6.8.5 5.7 0 4.5 0S2.2.5 1.3 1.3 0 3.3 0 4.5s.5 2.3 1.3 3.2S3.3 9 4.5 9s2.3-.5 3.2-1.3S9 5.7 9 4.5s-.5-2.3-1.3-3.2zm-3.2 7C2.4 8.3.7 6.6.7 4.5S2.4.7 4.5.7s3.8 1.7 3.8 3.8-1.7 3.8-3.8 3.8zm.4-4.2h1.6v.7H4.9v1.6h-.8V4.9H2.6v-.8h1.6V2.6h.7v1.5z"/>';
					break;

				case 'select' :

					$return_value = '<path d="M15 4h-14c-0.6 0-1 0.4-1 1v6c0 0.6 0.4 1 1 1h14c0.6 0 1-0.4 1-1v-6c0-0.6-0.4-1-1-1zM10 11h-9v-6h9v6zM13 8.4l-2-1.4h4l-2 1.4z"/>';
					break;

				case 'settings' :

					$return_value = '<path d="M16 9v-2l-1.7-0.6c-0.2-0.6-0.4-1.2-0.7-1.8l0.8-1.6-1.4-1.4-1.6 0.8c-0.5-0.3-1.1-0.6-1.8-0.7l-0.6-1.7h-2l-0.6 1.7c-0.6 0.2-1.2 0.4-1.7 0.7l-1.6-0.8-1.5 1.5 0.8 1.6c-0.3 0.5-0.5 1.1-0.7 1.7l-1.7 0.6v2l1.7 0.6c0.2 0.6 0.4 1.2 0.7 1.8l-0.8 1.6 1.4 1.4 1.6-0.8c0.5 0.3 1.1 0.6 1.8 0.7l0.6 1.7h2l0.6-1.7c0.6-0.2 1.2-0.4 1.8-0.7l1.6 0.8 1.4-1.4-0.8-1.6c0.3-0.5 0.6-1.1 0.7-1.8l1.7-0.6zM8 12c-2.2 0-4-1.8-4-4s1.8-4 4-4 4 1.8 4 4-1.8 4-4 4z"/><path d="M10.6 7.9c0 1.381-1.119 2.5-2.5 2.5s-2.5-1.119-2.5-2.5c0-1.381 1.119-2.5 2.5-2.5s2.5 1.119 2.5 2.5z"/>';
					break;

				case 'signature' :

					$return_value = '<path d="M13.3 3.9l-.6-.2a1 1 0 00-.6.2c-1 .8-1.7 1.8-2.1 3-.3.6-.4 1.2-.3 1.7.9-.3 1.8-.7 2.5-1.3.8-.6 1.3-1.4 1.5-2.3v-.6l-.4-.5zM0 12.4h15.6v1.2H0v-1.2zM2.1 8l1.3-1.3.8.8-1.3 1.3 1.3 1.3-.8.8-1.3-1.3-1.3 1.3-.8-.8 1.3-1.3L0 7.5l.8-.8L2.1 8zm13.6 2.8v.4h-1.2l-.1-.7c-.3-.2-.9-.1-1.8.2l-.4.1c-.6.2-1.2.2-1.8.1-.6-.1-1.1-.5-1.5-1-.9.2-2 .2-3.5.2V8.9l3.1-.1c-.1-.7 0-1.5.2-2.3.3-.8.7-1.5 1.2-2.2.5-.7 1.1-1.2 1.7-1.5.8-.5 1.6-.4 2.4.2.4.3.7.8.9 1.4.1.3 0 .6-.1 1s-.3.9-.6 1.3c-.3.5-.7.9-1.1 1.2-.8.7-1.8 1.2-2.8 1.6.5.3 1.2.3 1.8.1l1-.3c.7-.1 1.2-.1 1.6 0 .5.2.7.4.8.8l.2.7z"/>';
					break;

				case 'sort' :

					$return_value = '<path d="M11 7h-6l3-4z"/><path d="M5 9h6l-3 4z"/>';
					break;

				case 'spacer' :

					$return_value = '<path d="M7 7h1v1h-1v-1z"/><path d="M5 7h1v1h-1v-1z"/><path d="M3 7h1v1h-1v-1z"/><path d="M1 7h1v1h-1v-1z"/><path d="M6 6h1v1h-1v-1z"/><path d="M4 6h1v1h-1v-1z"/><path d="M2 6h1v1h-1v-1z"/><path d="M0 6h1v1h-1v-1z"/><path d="M7 5h1v1h-1v-1z"/><path d="M5 5h1v1h-1v-1z"/><path d="M3 5h1v1h-1v-1z"/><path d="M1 5h1v1h-1v-1z"/><path d="M6 4h1v1h-1v-1z"/><path d="M4 4h1v1h-1v-1z"/><path d="M2 4h1v1h-1v-1z"/><path d="M0 4h1v1h-1v-1z"/><path d="M7 3h1v1h-1v-1z"/><path d="M5 3h1v1h-1v-1z"/><path d="M3 3h1v1h-1v-1z"/><path d="M1 3h1v1h-1v-1z"/><path d="M6 2h1v1h-1v-1z"/><path d="M4 2h1v1h-1v-1z"/><path d="M2 2h1v1h-1v-1z"/><path d="M0 2h1v1h-1v-1z"/><path d="M7 1h1v1h-1v-1z"/><path d="M5 1h1v1h-1v-1z"/><path d="M3 1h1v1h-1v-1z"/><path d="M1 1h1v1h-1v-1z"/><path d="M6 0h1v1h-1v-1z"/><path d="M4 0h1v1h-1v-1z"/><path d="M2 0h1v1h-1v-1z"/><path d="M0 0h1v1h-1v-1z"/><path d="M15 7h1v1h-1v-1z"/><path d="M13 7h1v1h-1v-1z"/><path d="M11 7h1v1h-1v-1z"/><path d="M9 7h1v1h-1v-1z"/><path d="M14 6h1v1h-1v-1z"/><path d="M12 6h1v1h-1v-1z"/><path d="M10 6h1v1h-1v-1z"/><path d="M8 6h1v1h-1v-1z"/><path d="M15 5h1v1h-1v-1z"/><path d="M13 5h1v1h-1v-1z"/><path d="M11 5h1v1h-1v-1z"/><path d="M9 5h1v1h-1v-1z"/><path d="M14 4h1v1h-1v-1z"/><path d="M12 4h1v1h-1v-1z"/><path d="M10 4h1v1h-1v-1z"/><path d="M8 4h1v1h-1v-1z"/><path d="M15 3h1v1h-1v-1z"/><path d="M13 3h1v1h-1v-1z"/><path d="M11 3h1v1h-1v-1z"/><path d="M9 3h1v1h-1v-1z"/><path d="M14 2h1v1h-1v-1z"/><path d="M12 2h1v1h-1v-1z"/><path d="M10 2h1v1h-1v-1z"/><path d="M8 2h1v1h-1v-1z"/><path d="M15 1h1v1h-1v-1z"/><path d="M13 1h1v1h-1v-1z"/><path d="M11 1h1v1h-1v-1z"/><path d="M9 1h1v1h-1v-1z"/><path d="M14 0h1v1h-1v-1z"/><path d="M12 0h1v1h-1v-1z"/><path d="M10 0h1v1h-1v-1z"/><path d="M8 0h1v1h-1v-1z"/><path d="M7 15h1v1h-1v-1z"/><path d="M5 15h1v1h-1v-1z"/><path d="M3 15h1v1h-1v-1z"/><path d="M1 15h1v1h-1v-1z"/><path d="M6 14h1v1h-1v-1z"/><path d="M4 14h1v1h-1v-1z"/><path d="M2 14h1v1h-1v-1z"/><path d="M0 14h1v1h-1v-1z"/><path d="M7 13h1v1h-1v-1z"/><path d="M5 13h1v1h-1v-1z"/><path d="M3 13h1v1h-1v-1z"/><path d="M1 13h1v1h-1v-1z"/><path d="M6 12h1v1h-1v-1z"/><path d="M4 12h1v1h-1v-1z"/><path d="M2 12h1v1h-1v-1z"/><path d="M0 12h1v1h-1v-1z"/><path d="M7 11h1v1h-1v-1z"/><path d="M5 11h1v1h-1v-1z"/><path d="M3 11h1v1h-1v-1z"/><path d="M1 11h1v1h-1v-1z"/><path d="M6 10h1v1h-1v-1z"/><path d="M4 10h1v1h-1v-1z"/><path d="M2 10h1v1h-1v-1z"/><path d="M0 10h1v1h-1v-1z"/><path d="M7 9h1v1h-1v-1z"/><path d="M5 9h1v1h-1v-1z"/><path d="M3 9h1v1h-1v-1z"/><path d="M1 9h1v1h-1v-1z"/><path d="M6 8h1v1h-1v-1z"/><path d="M4 8h1v1h-1v-1z"/><path d="M2 8h1v1h-1v-1z"/><path d="M0 8h1v1h-1v-1z"/><path d="M15 15h1v1h-1v-1z"/><path d="M13 15h1v1h-1v-1z"/><path d="M11 15h1v1h-1v-1z"/><path d="M9 15h1v1h-1v-1z"/><path d="M14 14h1v1h-1v-1z"/><path d="M12 14h1v1h-1v-1z"/><path d="M10 14h1v1h-1v-1z"/><path d="M8 14h1v1h-1v-1z"/><path d="M15 13h1v1h-1v-1z"/><path d="M13 13h1v1h-1v-1z"/><path d="M11 13h1v1h-1v-1z"/><path d="M9 13h1v1h-1v-1z"/><path d="M14 12h1v1h-1v-1z"/><path d="M12 12h1v1h-1v-1z"/><path d="M10 12h1v1h-1v-1z"/><path d="M8 12h1v1h-1v-1z"/><path d="M15 11h1v1h-1v-1z"/><path d="M13 11h1v1h-1v-1z"/><path d="M11 11h1v1h-1v-1z"/><path d="M9 11h1v1h-1v-1z"/><path d="M14 10h1v1h-1v-1z"/><path d="M12 10h1v1h-1v-1z"/><path d="M10 10h1v1h-1v-1z"/><path d="M8 10h1v1h-1v-1z"/><path d="M15 9h1v1h-1v-1z"/><path d="M13 9h1v1h-1v-1z"/><path d="M11 9h1v1h-1v-1z"/><path d="M9 9h1v1h-1v-1z"/><path d="M14 8h1v1h-1v-1z"/><path d="M12 8h1v1h-1v-1z"/><path d="M10 8h1v1h-1v-1z"/><path d="M8 8h1v1h-1v-1z"/>';
					break;

				case 'submit' :

					$return_value = '<path d="M16 7.9l-6-4.9v3c-0.5 0-1.1 0-2 0-8 0-8 8-8 8s1-4 7.8-4c1.1 0 1.8 0 2.2 0v2.9l6-5z"/>';
					break;

				case 'table' :

					$return_value = '<path d="M0 1v15h16v-15h-16zM5 15h-4v-2h4v2zM5 12h-4v-2h4v2zM5 9h-4v-2h4v2zM5 6h-4v-2h4v2zM10 15h-4v-2h4v2zM10 12h-4v-2h4v2zM10 9h-4v-2h4v2zM10 6h-4v-2h4v2zM15 15h-4v-2h4v2zM15 12h-4v-2h4v2zM15 9h-4v-2h4v2zM15 6h-4v-2h4v2z"/>';
					break;

				case 'template_add' :

					$return_value = '<path d="M5.9 4.6c-1 0-.3-1.4-1.4-1.4H.7c-.4 0-.7.3-.7.7v3.6l.1 6.2c0 .3.3.6.7.6h12.7c.4 0 .7-.3.7-.6l-.1-3c-.4.1-.6.3-1.1.3-5 .7-6.6-4-5.9-6.4"/><path d="M11.9 2C9.6 2 7.8 3.8 7.8 6.1s1.8 4.1 4.1 4.1S16 8.4 16 6.1 14.2 2 11.9 2zm2 4.9h-1.2v1.2c0 .4-.3.8-.8.8-.4 0-.8-.3-.8-.8V6.9H9.9c-.4 0-.8-.3-.8-.8 0-.4.3-.8.8-.8h1.2V4.1c0-.4.3-.8.8-.8.4 0 .8.3.8.8v1.2h1.2c.4 0 .8.3.8.8 0 .4-.3.8-.8.8z"/>';
					break;

				case 'tel' :

					$return_value = '<path d="M12.2 10c-1.1-0.1-1.7 1.4-2.5 1.8-1.3 0.7-3.7-1.8-3.7-1.8s-2.5-2.4-1.9-3.7c0.5-0.8 2-1.4 1.9-2.5-0.1-1-2.3-4.6-3.4-3.6-2.4 2.2-2.6 3.1-2.6 4.9-0.1 3.1 3.9 7 3.9 7 0.4 0.4 3.9 4 7 3.9 1.8 0 2.7-0.2 4.9-2.6 1-1.1-2.5-3.3-3.6-3.4z"/>';
					break;

				case 'text' :

					$return_value = '<path d="M16 5c0-0.6-0.4-1-1-1h-14c-0.6 0-1 0.4-1 1v6c0 0.6 0.4 1 1 1h14c0.6 0 1-0.4 1-1v-6zM15 11h-14v-6h14v6z"/><path d="M2 6h1v4h-1v-4z"/>';
					break;

				case 'textarea' :

					$return_value = '<path d="M2 2h1v4h-1v-4z"/><path d="M1 0c-0.6 0-1 0.4-1 1v14c0 0.6 0.4 1 1 1h15v-16h-15zM13 15h-12v-14h12v14zM15 15v0h-1v-1h1v1zM15 13h-1v-10h1v10zM15 2h-1v-1h1v1z"/>';
					break;

				case 'texteditor' :

					$return_value = '<path d="M16 4c0 0 0-1-1-2s-1.9-1-1.9-1l-1.1 1.1v-2.1h-12v16h12v-8l4-4zM6.3 11.4l-0.6-0.6 0.3-1.1 1.5 1.5-1.2 0.2zM7.2 9.5l-0.6-0.6 5.2-5.2c0.2 0.1 0.4 0.3 0.6 0.5zM14.1 2.5l-0.9 1c-0.2-0.2-0.4-0.3-0.6-0.5l0.9-0.9c0.1 0.1 0.3 0.2 0.6 0.4zM11 15h-10v-14h10v2.1l-5.9 5.9-1.1 4.1 4.1-1.1 2.9-3v6z"/>';
					break;

				case 'tools' :

					$return_value = '<path d="M10.3 8.2l-0.9 0.9 0.9 0.9-1.2 1.2 4.3 4.3c0.6 0.6 1.5 0.6 2.1 0s0.6-1.5 0-2.1l-5.2-5.2zM14.2 15c-0.4 0-0.8-0.3-0.8-0.8 0-0.4 0.3-0.8 0.8-0.8s0.8 0.3 0.8 0.8c0 0.5-0.3 0.8-0.8 0.8z"/><path d="M3.6 8l0.9-0.6 1.5-1.7 0.9 0.9 0.9-0.9-0.1-0.1c0.2-0.5 0.3-1 0.3-1.6 0-2.2-1.8-4-4-4-0.6 0-1.1 0.1-1.6 0.3l2.9 2.9-2.1 2.1-2.9-2.9c-0.2 0.5-0.3 1-0.3 1.6 0 2.1 1.6 3.7 3.6 4z"/><path d="M8 10.8l0.9-0.8-0.9-0.9 5.7-5.7 1.2-0.4 1.1-2.2-0.7-0.7-2.3 1-0.5 1.2-5.6 5.7-0.9-0.9-0.8 0.9c0 0 0.8 0.6-0.1 1.5-0.5 0.5-1.3-0.1-2.8 1.4-0.5 0.5-2.1 2.1-2.1 2.1s-0.6 1 0.6 2.2 2.2 0.6 2.2 0.6 1.6-1.6 2.1-2.1c1.4-1.4 0.9-2.3 1.3-2.7 0.9-0.9 1.6-0.2 1.6-0.2zM4.9 10.4l0.7 0.7-3.8 3.8-0.7-0.7z"/>';
					break;

				case 'turnstile' :

					$return_value = '<path d="m10.9 11.1.1-.3c.1-.3.1-.6-.1-.9-.2-.2-.4-.3-.7-.3H4.4c-.1 0-.1-.1-.1-.1 0-.1.1-.1.1-.1l5.8-.1c.7 0 1.4-.6 1.7-1.3l.3-.9V7c-.5-2-2.5-3.3-4.5-2.9-1.2.3-2.2 1.2-2.7 2.5-.7-.6-1.8-.4-2.4.3-.3.4-.4 1-.2 1.5C1 8.4 0 9.5 0 10.8v.3c0 .1.1.1.1.1h10.7c.1 0 .1 0 .1-.1zM12.8 7.1h-.2s-.1 0-.1.1l-.1.8c-.1.3-.1.6.1.9.2.2.4.3.7.3l1.2.1h.1v.1c0 .1-.1.1-.1.1l-1.3.1c-.7 0-1.4.6-1.7 1.3l-.1.2v.1h4.4c.1 0 .1 0 .1-.1.5-1.7-.5-3.4-2.2-3.9-.2 0-.5-.1-.8-.1z"/>';
					break;

				case 'undo' :

					$return_value = '<path d="M8 0c-3 0-5.6 1.6-6.9 4.1l-1.1-1.1v4h4l-1.5-1.5c1-2 3.1-3.5 5.5-3.5 3.3 0 6 2.7 6 6s-2.7 6-6 6c-1.8 0-3.4-0.8-4.5-2.1l-1.5 1.3c1.4 1.7 3.6 2.8 6 2.8 4.4 0 8-3.6 8-8s-3.6-8-8-8z"/><text class="count" font-size="7" line-spacing="7" x="50%" y="50%" dominant-baseline="middle" text-anchor="middle"></text>';
					break;

				case 'up' :

					$return_value = '<path d="M1 13h14L8 3 1 13z"/>';
					break;

				case 'upload' :

					$return_value = '<path d="M15,7h-2l-1,1h2v7H2V8h2L3,7H1v9h14V7z"/><path d="M8,10l4-5h-2V0L6,0v5H4L8,10z"/>';
					break;

				case 'url' :

					$return_value = '<path d="M14.9 1.1c-1.4-1.4-3.7-1.4-5.1 0l-4.4 4.3c-1.4 1.5-1.4 3.7 0 5.2 0.1 0.1 0.3 0.2 0.4 0.3l1.5-1.5c-0.1-0.1-0.3-0.2-0.4-0.3-0.6-0.6-0.6-1.6 0-2.2l4.4-4.4c0.6-0.6 1.6-0.6 2.2 0s0.6 1.6 0 2.2l-1.3 1.3c0.4 0.8 0.5 1.7 0.4 2.5l2.3-2.3c1.5-1.4 1.5-3.7 0-5.1z"/><path d="M10.2 5.1l-1.5 1.5c0 0 0.3 0.2 0.4 0.3 0.6 0.6 0.6 1.6 0 2.2l-4.4 4.4c-0.6 0.6-1.6 0.6-2.2 0s-0.6-1.6 0-2.2l1.3-1.3c-0.4-0.8-0.1-1.3-0.4-2.5l-2.3 2.3c-1.4 1.4-1.4 3.7 0 5.1s3.7 1.4 5.1 0l4.4-4.4c1.4-1.4 1.4-3.7 0-5.1-0.2-0.1-0.4-0.3-0.4-0.3z"/>';
					break;

				case 'visible' :

					$return_value = '<path d="M8 3.9c-6.7 0-8 5.1-8 5.1s2.2 4.1 7.9 4.1 8.1-4 8.1-4-1.3-5.2-8-5.2zM5.3 5.4c0.5-0.3 1.3-0.3 1.3-0.3s-0.5 0.9-0.5 1.6c0 0.7 0.2 1.1 0.2 1.1l-1.1 0.2c0 0-0.3-0.5-0.3-1.2 0-0.8 0.4-1.4 0.4-1.4zM7.9 12.1c-4.1 0-6.2-2.3-6.8-3.2 0.3-0.7 1.1-2.2 3.1-3.2-0.1 0.4-0.2 0.8-0.2 1.3 0 2.2 1.8 4 4 4s4-1.8 4-4c0-0.5-0.1-0.9-0.2-1.3 2 0.9 2.8 2.5 3.1 3.2-0.7 0.9-2.8 3.2-7 3.2z"/>';
					break;

				case 'warning' :

					$return_value = '<path d="M8 1l-8 14h16l-8-14zM8 13c-0.6 0-1-0.4-1-1s0.4-1 1-1 1 0.4 1 1c0 0.6-0.4 1-1 1zM7 10v-4h2v4h-2z"/>';
					break;

				case 'woo' :

					$return_value = '<path d="M2 0h12c.6 0 1 .2 1.4.6.4.3.6.8.6 1.3v10.2c0 .5-.2 1-.6 1.4-.4.4-.9.6-1.4.6H9.5V16l-2-1.9H2c-.6 0-1-.2-1.4-.6-.4-.4-.6-.8-.6-1.4V1.9C0 1.4.2.9.6.5 1 .2 1.4 0 2 0zm5.6 4.7c0-.2 0-.3-.1-.3-.1-.1-.2-.1-.3-.1-.2 0-.4.2-.5.5-.1.3-.2.7-.3 1-.2.4-.2.7-.3 1.1v.6c-.1-.3-.2-.5-.2-.7-.1-.3-.1-.5-.2-.6 0-.1-.1-.3-.2-.6 0-.3-.1-.4-.3-.4-.1 0-.2.1-.4.4-.2.3-.4.5-.5.9-.2.3-.3.6-.4.9-.2.2-.2.4-.3.4v-.1-.1c-.1-.5-.2-1-.2-1.5-.1-.5-.1-1-.2-1.4 0-.1-.1-.2-.2-.2s-.2-.1-.2-.1c-.2 0-.3.1-.4.2 0 .1-.1.3-.1.4 0 .1.1.4.2 1s.2 1.1.3 1.6c0 .1.1.4.2 1s.3.9.5.9c.1 0 .3-.1.5-.4.1-.1.3-.4.4-.7.2-.3.3-.6.4-.9l.2-.4s.1.2.1.5l.3.9c.2.2.4.5.6.8.2.3.4.4.5.4.1 0 .2 0 .3-.1 0-.1.1-.2.1-.3V8.1c0-.3 0-.6.1-1s.2-.8.2-1.1c.1-.3.2-.6.2-.9l.2-.4zm2.6.7c-.2-.4-.6-.6-1-.6s-.8.1-1 .4c-.3.3-.5.8-.6 1.3V7.8c0 .1.1.3.2.5.2.4.4.5.7.6 0 .1.1.1.2.1h.2c.6 0 1-.3 1.3-.9.3-.6.4-1.1.4-1.5-.1-.4-.2-.8-.4-1.2zm-.6 1.3c0 .1-.1.4-.2.8s-.3.6-.5.6-.3-.1-.4-.4c-.1-.4-.1-.5-.1-.6 0-.1.1-.3.2-.7.1-.4.3-.6.6-.6.2 0 .3.1.4.4v.5zm3.9-1.3c-.2-.4-.6-.6-1-.6s-.8.1-1 .4c-.3.3-.5.8-.6 1.3 0 .3-.1.5-.1.7 0 .2 0 .4.1.6 0 .1.1.3.2.5s.3.4.6.5c.1 0 .1 0 .2.1h.2c.6 0 1-.3 1.3-.9.3-.6.4-1.1.4-1.5 0-.3-.1-.7-.3-1.1zm-.8 2.1c-.1.4-.3.6-.6.6-.2 0-.3-.1-.4-.4 0-.3-.1-.5-.1-.5 0-.1 0-.3.1-.7.1-.4.3-.6.6-.6.2 0 .3.1.4.4 0 .2.1.4.1.4.1.1 0 .4-.1.8z"/><path fill="none" d="M174.6 238.5h-8.5 8.5z"/>';
					break;

				default :

					$return_value = '<path d="M9 11h-3c0-3 1.6-4 2.7-4.6 0.4-0.2 0.7-0.4 0.9-0.6 0.5-0.5 0.3-1.2 0.2-1.4-0.3-0.7-1-1.4-2.3-1.4-2.1 0-2.5 1.9-2.5 2.3l-3-0.4c0.2-1.7 1.7-4.9 5.5-4.9 2.3 0 4.3 1.3 5.1 3.2 0.7 1.7 0.4 3.5-0.8 4.7-0.5 0.5-1.1 0.8-1.6 1.1-0.9 0.5-1.2 1-1.2 2z"/><path d="M9.5 14c0 1.105-0.895 2-2 2s-2-0.895-2-2c0-1.105 0.895-2 2-2s2 0.895 2 2z"/>';
			}

			return sprintf('<svg height="16" width="16" viewBox="0 0 16 16">%s</svg>', $return_value);
		}
	}
